using System;
using System.IO;
using System.Xml;
using System.Collections;

namespace Team_Project
{
	/// <summary>
	/// Livello di autenticazione. Riconosce l'utente, ne verifica le credenziali
	/// e ne scopre il ruolo
	/// </summary>
	public class AuthenticationLayer: MarshalByRefObject, IOperationHandler
	{
		private object chTkn;
		/// <summary>
		/// Crea un'istanza.
		/// </summary>
		public AuthenticationLayer()
		{
		}
		#region IOperationHandler Members
		/// <summary>
		/// Ottiene o imposta il token utilizzato dall'engine per identificare
		/// l'operation handler e restituire il successivo nella catena.
		/// </summary>
		public object ChainToken
		{
			get{return chTkn;}
			set{chTkn = value;}
		}

		/// <summary>
		/// Effettua l'autenticazione e passa i dati al livello successivo
		/// </summary>
		/// <param name="data">Dati calcolati dai livelli precedenti</param>
		/// <param name="fullXml">Stringa contenente l'xml di richiesta</param>
		/// <param name="ok">In uscita contiene l'esito dell'operazione</param>
		/// <returns>Una stringa xml di risposta. Nel caso l'operazione non
		/// sia andata a buon fine la stringa di risposta  un xml contenete la 
		/// descrizione dell'errore avvenuto che pu essere restituito al
		/// cliente</returns>
		public string Compute(IDictionary data,string fullXml, out bool ok)
		{
			XmlTextReader xtr = new XmlTextReader(new StringReader(fullXml));
			Stream result;
			xtr.WhitespaceHandling = WhitespaceHandling.None;
			if(!xtr.Read() || xtr.Name != "TeamProjectRequest")
			{
				ok = false;
				result = TPEngine.FormatError("TeamProjectRequest");
			}
			else
				result = Compute(data,xtr,out ok);
			StreamReader sr = new StreamReader(result);
			return sr.ReadToEnd();
		}
		/// <summary>
		/// Effettua l'autenticazione e passa i dati al livello successivo
		/// </summary>
		/// <param name="data">Dati calcolati dai livelli precedenti</param>
		/// <param name="tr">XmlReader posizionato all'elemento precedente al primo
		/// interessante per questo handler</param>
		/// <param name="ok">In uscita contiene l'esito dell'operazione</param>
		/// <returns>Una stringa xml di risposta. Nel caso l'operazione non
		/// sia andata a buon fine la stringa di risposta  un xml contenete la 
		/// descrizione dell'errore avvenuto che pu essere restituito al
		/// cliente</returns>
		public Stream Compute(System.Collections.IDictionary data, System.Xml.XmlTextReader tr, out bool ok)
		{
			ok = false;
			if(!tr.Read() || tr.Name != "Authentication")
				return TPEngine.FormatError("Authentication");
			if(!tr.Read() || tr.Name != "UserName")
				return TPEngine.FormatError("UserName");
			if(!tr.Read() || tr.NodeType != XmlNodeType.Text)
				return TPEngine.FormatError("UserName text");
			string usrName = tr.Value;
			if(usrName == string.Empty)
				return TPEngine.FormatError("UserName Name not empty");
			if(!tr.Read() || tr.NodeType != XmlNodeType.EndElement)
				return TPEngine.FormatError("UserName end element");
			if(!tr.Read() || tr.Name != "Password")
				return TPEngine.FormatError("Password");
			if(!tr.Read() || tr.NodeType != XmlNodeType.Text)
				return TPEngine.FormatError("Password text");
			string psw = tr.Value;
			if(psw == string.Empty)
				return TPEngine.FormatError("Password not empty");
			if(!tr.Read() || tr.NodeType != XmlNodeType.EndElement)
				return TPEngine.FormatError("Password end element");
			if(!tr.Read() || tr.NodeType != XmlNodeType.EndElement)
				return TPEngine.FormatError("Authentication end element");

			if(psw != "password")
				return AuthenticationError(usrName);

			data["userID"] = usrName;
			MsgElabChainManager mChm = (MsgElabChainManager)Globals.Instance.Data["ChainManager"];
			IOperationHandler oh = mChm.GetNextLevel(ChainToken);
			bool ok2;
			Stream res = oh.Compute(data,tr,out ok2);
			ok=ok2;
			return res;
		}

		#endregion

		/// <summary>
		/// Scrive l'xml che segnala l'errore di autenticazione
		/// </summary>
		/// <param name="usrName">Nome dell'utente che non 
		/// stato riconosciuto</param>
		/// <returns>Un memory stream contenente l'xml di risposta</returns>
		protected Stream AuthenticationError(string usrName)
		{
			MemoryStream ms = new MemoryStream();
			XmlTextWriter tw = new XmlTextWriter(ms,System.Text.Encoding.UTF8);
			tw.WriteStartDocument(true);
			tw.WriteStartElement("TeamProjectResponse");
			tw.WriteStartElement("Error");
			tw.WriteString("Authentication failed for user " + usrName);
			tw.WriteEndElement();
			tw.WriteEndElement();
			tw.Flush();
			ms.Position = 0;
			return ms;
		}
	}
}
